/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.world.structure;

import com.barion.dungeons_enhanced.DEStructures;
import com.barion.dungeons_enhanced.world.DEJigsawTypes;
import com.barion.dungeons_enhanced.world.DETemplatePools;
import com.legacy.structure_gel.api.structure.jigsaw.ExtendedJigsawStructurePiece;
import com.legacy.structure_gel.api.structure.jigsaw.IPieceFactory;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawCapability;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawPoolBuilder;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawRegistryHelper;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class DEMonsterMaze {
    public static final String ID = "monster_maze";

    public static void pool(BootstapContext<StructureTemplatePool> context) {
        JigsawRegistryHelper registry = new JigsawRegistryHelper("dungeons_enhanced", "monster_maze/", context);
        registry.registerBuilder().pools(registry.poolBuilder().names(new String[]{"root"}).maintainWater(false)).register(DETemplatePools.MONSTER_MAZE);
        JigsawPoolBuilder basicPool = registry.poolBuilder().maintainWater(false);
        JigsawPoolBuilder CrossTunnels = basicPool.clone().names(new String[]{"tunnels/cross1", "tunnels/cross2"});
        JigsawPoolBuilder EdgeTunnels = basicPool.clone().names(new String[]{"tunnels/edge1", "tunnels/edge2"});
        JigsawPoolBuilder RoomTunnels = basicPool.clone().names(new String[]{"tunnels/room1", "tunnels/room2", "tunnels/room3"});
        JigsawPoolBuilder ShortTunnels = basicPool.clone().names(new String[]{"tunnels/small1", "tunnels/small2", "tunnels/small3"});
        JigsawPoolBuilder LongTunnels = basicPool.clone().names(new String[]{"tunnels/big1", "tunnels/big2", "tunnels/big3", "tunnels/big4", "tunnels/big5"});
        JigsawPoolBuilder StartStairs = basicPool.clone().names(new String[]{"stairs/big1", "stairs/big2"});
        JigsawPoolBuilder Stairs = basicPool.clone().names(new String[]{"stairs/big1", "stairs/big2", "stairs/big3"});
        JigsawPoolBuilder Rooms = basicPool.clone().names(new String[]{"big_room", "church", "prison", "room1", "storage", "brewery"});
        JigsawPoolBuilder Boss = basicPool.clone().names(new String[]{"boss"});
        registry.register("tunnels/cross", CrossTunnels);
        registry.register("tunnels/edge", EdgeTunnels);
        registry.register("tunnels/room", RoomTunnels);
        registry.register("tunnels/small", ShortTunnels);
        registry.register("tunnels/big", LongTunnels);
        registry.register("start_stairs", StartStairs);
        registry.register("stairs", Stairs);
        registry.register("rooms", Rooms);
        registry.register("boss", Boss);
        registry.register("tree", basicPool.clone().names(new String[]{"tree"}));
        registry.register("tunnels", (List)JigsawPoolBuilder.collect((JigsawPoolBuilder[])new JigsawPoolBuilder[]{EdgeTunnels, RoomTunnels, ShortTunnels, LongTunnels}));
        registry.register("main", (List)JigsawPoolBuilder.collect((JigsawPoolBuilder[])new JigsawPoolBuilder[]{EdgeTunnels.weight(4), RoomTunnels.weight(3), ShortTunnels.weight(2), LongTunnels.weight(3), CrossTunnels.weight(5), Rooms.weight(2)}));
    }

    public static class Piece
    extends ExtendedJigsawStructurePiece {
        public Piece(IPieceFactory.Context context) {
            super(context);
        }

        public Piece(StructurePieceSerializationContext serializationContext, CompoundTag nbt) {
            super(serializationContext, nbt);
        }

        public StructurePieceType m_210000_() {
            return (StructurePieceType)DEStructures.MONSTER_MAZE.getPieceType().get();
        }

        public void handleDataMarker(String key, BlockPos pos, ServerLevelAccessor levelAccessor, RandomSource random, BoundingBox box) {
        }
    }

    public static class Capability
    implements JigsawCapability.IJigsawCapability {
        public static final Capability INSTANCE = new Capability();
        public static final Codec<Capability> CODEC = Codec.unit((Object)INSTANCE);

        public JigsawCapability.JigsawType<?> getType() {
            return DEJigsawTypes.MONSTER_MAZE;
        }

        public IPieceFactory getPieceFactory() {
            return Piece::new;
        }
    }
}

